---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-Syslog INFO通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.Daemon.pas` 行260 - Syslog(LOG_INFO, Format(START_RUNNING, [FHost, FPort]))
- E-02: `src/Horse.Provider.Daemon.pas` 行203 - openlog(nil, LOG_PID or LOG_NDELAY, LOG_DAEMON)
- E-03: `src/Horse.Constants.pas` 行12 - START_RUNNING = 'Server is running on %s:%d'
- E-04: `src/Horse.Constants.pas` 行10 - DEFAULT_HOST = '0.0.0.0'
- E-05: `src/Horse.Constants.pas` 行11 - DEFAULT_PORT = 9000
- E-06: `src/ThirdParty.Posix.Syslog.pas` 行62 - LOG_INFO = 6
- E-07: `src/ThirdParty.Posix.Syslog.pas` 行33 - LOG_DAEMON = 3 shl 3
- E-08: `src/Horse.Provider.Daemon.pas` 行257 - LIdHTTPWebBrokerBridge.StartListening
- E-09: `src/Horse.Provider.Daemon.pas` 行259 - DoOnListen
- E-10: `src/Horse.Provider.Daemon.pas` 行263 - Syslog(LOG_ERR, E.ClassName + ': ' + E.Message)
- E-11: `src/ThirdParty.Posix.Syslog.pas` 行22 - LOG_PID = $01
- E-12: `src/ThirdParty.Posix.Syslog.pas` 行25 - LOG_NDELAY = $08

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知はLOG_INFO優先度でsyslogに送信される | E-01, E-06 | ○ |
| C-02 | メッセージ形式は「Server is running on %s:%d」 | E-03 | ○ |
| C-03 | デフォルトホストは'0.0.0.0' | E-04 | ○ |
| C-04 | デフォルトポートは9000 | E-05 | ○ |
| C-05 | syslogはLOG_DAEMONファシリティを使用 | E-02, E-07 | ○ |
| C-06 | StartListening成功後に送信される | E-08, E-01 | ○ |
| C-07 | DoOnListenコールバック実行後に送信される | E-09, E-01 | ○ |
| C-08 | 起動失敗時はLOG_ERRで別のメッセージが送信される | E-10 | ○ |
| C-09 | LOG_PIDオプションが使用される | E-02, E-11 | ○ |
| C-10 | LOG_NDELAYオプションが使用される | E-02, E-12 | ○ |
| C-11 | FHostとFPortがテンプレート変数として使用される | E-01 | ○ |
| C-12 | 同期方式で送信される（syslogシステムコール） | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `Horse.Provider.Daemon.pas`の行260でSyslog(LOG_INFO, ...)が呼ばれていることを確認
- [ ] `Horse.Constants.pas`のSTART_RUNNING定数が'Server is running on %s:%d'であることを確認
- [ ] syslogのファシリティがLOG_DAEMONであることを確認
